﻿using System;

namespace Composing
{
    class Program
    {
        static void Fragments()
        {
            // Listing 10-55. Konkatenacja łańcuchów znaków.
            string fragment1 = "Być albo nie być ";
            string fragment2 = " - oto jest pytanie.";
            string composedString = fragment1 + fragment2;
            Console.WriteLine(composedString);

            // Listing 10-56. Jawne wywołanie metody String.Concat.
            string composedString2 = string.Concat(fragment1, fragment2);
            Console.WriteLine(composedString2);
        }

        // Listing 10-57. Konkatenacja tablicy łańcuchów znaków.
        static void Main(string[] args)
        {
            string[] strings = Soliloquize();
            // Proszę zmienić to na false by użyć wersji z listingu 10-58.
#if true
            string output = String.Concat(strings);
#else
            // Listing 10-58. Metoda String.Join
            string output = String.Join(Environment.NewLine, strings);
#endif
            Console.WriteLine(output);
            Console.ReadKey();
        }
        private static string[] Soliloquize()
        {
            return new string[] {
                "Być albo nie być - oto jest pytanie.",
                "Kto postępuje godniej: ten, kto biernie",
                "Stoi pod gradem zajadłych strzał losu,",
                "Czy ten, kto stawia opór morzu nieszczęść",
                "I w walce kładzie im kres?" };
        }
    }
}
